<?php
function pa_add_admin_menu() {
    add_menu_page(
        'Precio Alternativo WooCommerce',
        'Precio Alternativo',
        'manage_options',
        'precio_alternativo',
        'pa_options_page',
        'dashicons-cart',
        20
    );
}
add_action('admin_menu', 'pa_add_admin_menu');

function pa_options_page() {
    // Guardar opciones
    if (isset($_POST['pa_save_settings'])) {
        update_option('pa_discount_percentage', sanitize_text_field($_POST['pa_discount_percentage']));
        update_option('pa_installment_count', sanitize_text_field($_POST['pa_installment_count']));
        update_option('pa_min_amount_installment', sanitize_text_field($_POST['pa_min_amount_installment']));
        update_option('pa_min_amount_discount', sanitize_text_field($_POST['pa_min_amount_discount']));
        echo '<div class="updated"><p>Configuraciones guardadas.</p></div>';
    }

    // Obtener las opciones guardadas
    $discount_percentage = get_option('pa_discount_percentage', '20'); // Valor por defecto 20%
    $installment_count = get_option('pa_installment_count', '3'); // Valor por defecto 3
    $min_amount_installment = get_option('pa_min_amount_installment', '0'); // Valor por defecto 0
    $min_amount_discount = get_option('pa_min_amount_discount', '0'); // Valor por defecto 0
?>
    <div class="wrap">
        <h1>Precio Alternativo WooCommerce</h1>
        <form method="post" action="">
            <h2>Configuraciones</h2>
            <!-- Texto de bienvenida y descripción del plugin -->
            <p>Bienvenido al plugin <strong>Precio Alternativo WooCommerce</strong>. Este plugin te permite configurar precios alternativos para tus productos, como precios con descuento y en cuotas. Utiliza las configuraciones a continuación para ajustar el porcentaje de descuento y la cantidad de cuotas que deseas aplicar globalmente. Si no configuras nada, se usarán los valores por defecto.</p>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="pa_discount_percentage">Porcentaje de Descuento (%)</label></th>
                    <td><input type="number" id="pa_discount_percentage" name="pa_discount_percentage" value="<?php echo esc_attr($discount_percentage); ?>" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="pa_installment_count">Número de Cuotas</label></th>
                    <td><input type="number" id="pa_installment_count" name="pa_installment_count" value="<?php echo esc_attr($installment_count); ?>" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="pa_min_amount_installment">Monto Mínimo para Cuotificar</label></th>
                    <td>
                        <input type="number" id="pa_min_amount_installment" name="pa_min_amount_installment" value="<?php echo esc_attr($min_amount_installment); ?>" step="1" min="0" />
                        <p class="description">Si el producto cuesta menos que este monto, NO se mostrará el precio en cuotas. Dejar en 0 para aplicar a todos los productos.</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="pa_min_amount_discount">Monto Mínimo para Descuento al Contado</label></th>
                    <td>
                        <input type="number" id="pa_min_amount_discount" name="pa_min_amount_discount" value="<?php echo esc_attr($min_amount_discount); ?>" step="1" min="0" />
                        <p class="description">Si el producto cuesta menos que este monto, NO se aplicará el descuento al contado. Dejar en 0 para aplicar a todos los productos.</p>
                    </td>
                </tr>
            </table>

            <?php submit_button('Guardar Configuraciones', 'primary', 'pa_save_settings'); ?>
        </form>

        <h2>Shortcodes Disponibles</h2>
        <p>Utiliza los siguientes shortcodes para mostrar precios dentro de la página del producto:</p>
        <ul>
            <li><code id="shortcode_contado">[mostrar_precio_contado]</code> <button onclick="copyToClipboard('#shortcode_contado')">Copiar</button></li>
            <li><code id="shortcode_cuota">[mostrar_precio_cuota]</code> <button onclick="copyToClipboard('#shortcode_cuota')">Copiar</button></li>
            <li><code id="shortcode_contado_rebajado">[mostrar_precio_contado_rebajado]</code> <button onclick="copyToClipboard('#shortcode_contado_rebajado')">Copiar</button></li>
            <li><code id="shortcode_cuota_rebajado">[mostrar_precio_cuota_rebajado]</code> <button onclick="copyToClipboard('#shortcode_cuota_rebajado')">Copiar</button></li>
        </ul>

        <p>Utiliza los siguientes shortcodes para mostrar precios fuera de la página del producto. Remplazar "123" por el ID del producto:</p>
        <ul>
            <li><code id="shortcode_contado_product_id">[mostrar_precio_contado product_id="123"]</code> <button onclick="copyToClipboard('#shortcode_contado_product_id')">Copiar</button></li>
            <li><code id="shortcode_cuota_product_id">[mostrar_precio_cuota product_id="123"]</code> <button onclick="copyToClipboard('#shortcode_cuota_product_id')">Copiar</button></li>
            <li><code id="shortcode_contado_rebajado_product_id">[mostrar_precio_contado_rebajado product_id="123"]</code> <button onclick="copyToClipboard('#shortcode_contado_rebajado_product_id')">Copiar</button></li>
            <li><code id="shortcode_cuota_rebajado_product_id">[mostrar_precio_cuota_rebajado product_id="123"]</code> <button onclick="copyToClipboard('#shortcode_cuota_rebajado_product_id')">Copiar</button></li>
        </ul>

        <script>
        function copyToClipboard(element) {
            var $temp = document.createElement("input");
            document.body.appendChild($temp);
            $temp.value = document.querySelector(element).textContent;
            $temp.select();
            document.execCommand("copy");
            document.body.removeChild($temp);
        }
        </script>

        <h2>Filtrar productos por stock</h2>
        <p>Ahora puedes permitir que los usuarios vean solo los productos en stock agregando un parámetro en la URL.</p>
        
        <h3>Cómo usarlo</h3>
        <p>Para mostrar solo los productos en stock en una categoría o listado, agrega <code>?stock=true</code> al final de la URL.</p>
        
        <h3>Agregar un botón de filtrado</h3>
        <p>Puedes incluir un botón en tu sitio web para que los usuarios activen este filtro fácilmente:</p>
        <pre><code>&lt;a href="?stock=true" class="btn-filtrar-stock"&gt;Mostrar solo productos en stock&lt;/a&gt;</code></pre>
        
        <p>Con esta funcionalidad, los clientes podrán encontrar más fácilmente los productos disponibles en tu tienda.</p>

        <!-- Mensaje de agradecimiento y enlace a tu web -->
        <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
            <p>Gracias por usar el plugin <strong>Precio Alternativo WooCommerce</strong>. Visita <a href="https://fersosa.com/" target="_blank">fersosa.com</a> para más información y otros proyectos.</p>
        </div>
    </div>
<?php
}
?>