<?php
// Filtrar solo productos en stock cuando se usa ?stock=true
add_action('pre_get_posts', function ($query) {

    if (
        !is_admin() &&
        $query->is_main_query() &&
        isset($_GET['stock']) &&
        $_GET['stock'] === 'true'
    ) {
        $meta_query = $query->get('meta_query') ?: [];

        $meta_query[] = [
            'key'     => '_stock_status',
            'value'   => 'instock',
            'compare' => '='
        ];

        $query->set('meta_query', $meta_query);
    }

});


// Evitar 404 solo cuando la página NO existe
add_action('template_redirect', function () {

    if (isset($_GET['stock']) && $_GET['stock'] === 'true') {
        global $wp_query;

        // Si estamos en una página paginada y no hay resultados
        if (is_paged() && $wp_query->post_count === 0) {
            wp_redirect(remove_query_arg('paged'));
            exit;
        }
    }

});
