<?php
// Añadir campos personalizados al backend del producto
function pa_add_custom_price_fields() {
    woocommerce_wp_text_input(
        array(
            'id'          => '_custom_price_contado',
            'label'       => __('Precio al Contado Personalizado', 'precio-alternativo'),
            'placeholder' => __('Dejar vacío para usar el cálculo estándar', 'precio-alternativo'),
            'type'        => 'number',
            'desc_tip'    => true,
            'description' => __('Define un precio específico al contado para este producto.', 'precio-alternativo'),
            'custom_attributes' => array(
                'step' => '1',
                'min'  => '0'
            ),
        )
    );

    woocommerce_wp_text_input(
        array(
            'id'          => '_custom_price_cuota',
            'label'       => __('Precio en Cuotas Personalizado', 'precio-alternativo'),
            'placeholder' => __('Dejar vacío para usar el cálculo estándar', 'precio-alternativo'),
            'type'        => 'number',
            'desc_tip'    => true,
            'description' => __('Define un precio específico en cuotas para este producto.', 'precio-alternativo'),
            'custom_attributes' => array(
                'step' => '1',
                'min'  => '0'
            ),
        )
    );
}
add_action('woocommerce_product_options_pricing', 'pa_add_custom_price_fields');

// Guardar los valores de los campos personalizados
function pa_save_custom_price_fields($post_id) {
    $custom_price_contado = isset($_POST['_custom_price_contado']) ? sanitize_text_field($_POST['_custom_price_contado']) : '';
    $custom_price_cuota = isset($_POST['_custom_price_cuota']) ? sanitize_text_field($_POST['_custom_price_cuota']) : '';

    if (!empty($custom_price_contado)) {
        update_post_meta($post_id, '_custom_price_contado', $custom_price_contado);
    } else {
        delete_post_meta($post_id, '_custom_price_contado');
    }

    if (!empty($custom_price_cuota)) {
        update_post_meta($post_id, '_custom_price_cuota', $custom_price_cuota);
    } else {
        delete_post_meta($post_id, '_custom_price_cuota');
    }
}
add_action('woocommerce_process_product_meta', 'pa_save_custom_price_fields');
?>
